/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLUtil;

class ContentReader
extends Reader {
    private IXMLReader reader;
    private IXMLEntityResolver entityResolver;
    private char escapeChar;
    private char[] delimiter;
    private String charsReadTooMuch;
    private int charsToGo;
    private boolean useLowLevelReader;
    private boolean pastInitialPrefix;

    ContentReader(IXMLReader reader, IXMLEntityResolver entityResolver, char escapeChar, char[] delimiter, boolean useLowLevelReader, String prefix) {
        this.delimiter = delimiter;
        this.charsToGo = this.delimiter.length;
        this.charsReadTooMuch = prefix;
        this.useLowLevelReader = useLowLevelReader;
        this.pastInitialPrefix = false;
        this.reader = reader;
        this.entityResolver = entityResolver;
        this.escapeChar = escapeChar;
    }

    protected void finalize() throws Throwable {
        this.reader = null;
        this.entityResolver = null;
        this.delimiter = null;
        this.charsReadTooMuch = null;
        super.finalize();
    }

    /*
     * WARNING - void declaration
     */
    public int read(char[] buffer, int offset, int size) throws IOException {
        int charsRead = 0;
        boolean[] isEntity = new boolean[]{false};
        if (offset + size > buffer.length) {
            size = buffer.length - offset;
        }
        while (this.charsToGo > 0 && charsRead < size) {
            void var6_6;
            char ch;
            if (this.charsReadTooMuch.length() > 0) {
                ch = this.charsReadTooMuch.charAt(0);
                this.charsReadTooMuch = this.charsReadTooMuch.substring(1);
            } else {
                this.pastInitialPrefix = true;
                try {
                    if (this.useLowLevelReader) {
                        ch = this.reader.read();
                    } else {
                        ch = XMLUtil.read(this.reader, isEntity, this.escapeChar, this.entityResolver);
                        if (!isEntity[0] && ch == '&') {
                            this.reader.startNewStream(XMLUtil.scanEntity(isEntity, this.reader, this.escapeChar, this.entityResolver));
                            ch = this.reader.read();
                        }
                    }
                }
                catch (XMLParseException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (isEntity[0]) {
                buffer[offset + charsRead] = var6_6;
                ++charsRead;
                continue;
            }
            if (var6_6 == this.delimiter[this.charsToGo - 1] && this.pastInitialPrefix) {
                --this.charsToGo;
                continue;
            }
            if (this.charsToGo < this.delimiter.length) {
                this.charsReadTooMuch = new String(this.delimiter, this.charsToGo + 1, this.delimiter.length - this.charsToGo) + (char)var6_6;
                this.charsToGo = this.delimiter.length;
                buffer[offset + charsRead] = this.delimiter[this.charsToGo - 1];
                ++charsRead;
                continue;
            }
            buffer[offset + charsRead] = var6_6;
            ++charsRead;
        }
        if (charsRead == 0) {
            charsRead = -1;
        }
        return charsRead;
    }

    /*
     * WARNING - void declaration
     */
    public void close() throws IOException {
        while (this.charsToGo > 0) {
            void var1_1;
            char ch;
            if (this.charsReadTooMuch.length() > 0) {
                ch = this.charsReadTooMuch.charAt(0);
                this.charsReadTooMuch = this.charsReadTooMuch.substring(1);
            } else if (this.useLowLevelReader) {
                ch = this.reader.read();
            } else {
                try {
                    ch = XMLUtil.read(this.reader, null, this.escapeChar, this.entityResolver);
                }
                catch (XMLParseException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (var1_1 == this.delimiter[this.charsToGo - 1]) {
                --this.charsToGo;
                continue;
            }
            if (this.charsToGo >= this.delimiter.length) continue;
            this.charsReadTooMuch = new String(this.delimiter, this.charsToGo + 1, this.delimiter.length - this.charsToGo) + (char)var1_1;
            this.charsToGo = this.delimiter.length;
        }
    }
}

